/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.ldtteam.structurize.items.ItemScanTool;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Explosions;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyPermissionEventHandler {
    private final Colony colony;
    private Map<UUID, Long> lastPlayerNotificationTick = new HashMap<UUID, Long>();

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.EntityPlaceEvent event) {
        Action action;
        Action action2 = action = event.getPlacedBlock().func_177230_c() instanceof AbstractBlockHut ? Action.PLACE_HUTS : Action.PLACE_BLOCKS;
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getEntity(), event.getPlacedBlock(), action)) {
            this.cancelEvent((Event)event, event.getEntity(), this.colony, action, event.getPos());
        }
    }

    private boolean checkBlockEventDenied(IWorld worldIn, BlockPos posIn, Entity entity, BlockState blockState, Action action) {
        if (entity instanceof PlayerEntity) {
            @NotNull PlayerEntity player = EntityUtils.getPlayerOfFakePlayer((PlayerEntity)entity, entity.field_70170_p);
            if (this.colony.isCoordInColony(entity.field_70170_p, posIn)) {
                if (blockState.func_177230_c() instanceof AbstractBlockHut && this.colony.getPermissions().hasPermission(player, action)) {
                    return false;
                }
                return !this.colony.getPermissions().hasPermission(player, action);
            }
        }
        return false;
    }

    private void cancelEvent(Event event, @Nullable Entity entity, Colony colony, Action action, BlockPos pos) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
            if (entity == null) {
                if (colony.hasTownHall()) {
                    colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(null, "-", action, pos));
                }
                return;
            }
            if (colony.hasTownHall()) {
                colony.getBuildingManager().getTownHall().addPermissionEvent(new PermissionEvent(entity.func_110124_au(), entity.func_200200_C_().getString(), action, pos));
            }
            if (entity instanceof FakePlayer) {
                return;
            }
            long worldTime = entity.field_70170_p.func_82737_E();
            if (!this.lastPlayerNotificationTick.containsKey(entity.func_110124_au()) || this.lastPlayerNotificationTick.get(entity.func_110124_au()) + (long)(20 * (Integer)MineColonies.getConfig().getServer().secondsBetweenPermissionMessages.get()) < worldTime) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo((PlayerEntity)entity);
                this.lastPlayerNotificationTick.put(entity.func_110124_au(), worldTime);
            }
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        if (!((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() || world.func_201670_d()) {
            return;
        }
        if (event.getState().func_177230_c() instanceof AbstractBlockHut) {
            @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(event.getPlayer().field_70170_p, event.getPos());
            if (building == null) {
                return;
            }
            if (event.getState().func_177230_c() == ModBlocks.blockHutTownHall && !((BlockHutTownHall)event.getState().func_177230_c()).getValidBreak() && !event.getPlayer().func_184812_l_()) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.BREAK_HUTS, event.getPos());
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Action.BREAK_HUTS) && this.checkEventCancelation(Action.BREAK_HUTS, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPos())) {
                return;
            }
            building.destroy();
            if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && event.getState().func_177230_c() == ModBlocks.blockHutTownHall) {
                IColonyManager.getInstance().deleteColonyByWorld(building.getColony().getID(), false, event.getPlayer().field_70170_p);
            }
        } else if (event.getState().func_177230_c() instanceof BlockDecorationController) {
            this.colony.getBuildingManager().removeLeisureSite(event.getPos());
        } else {
            this.checkEventCancelation(Action.BREAK_BLOCKS, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, event.getPos());
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (MineColonies.getConfig().getServer().turnOffExplosionsInColonies.get() == Explosions.DAMAGE_EVERYTHING) {
            return;
        }
        World eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> (!(entity instanceof IMob) || entity instanceof LlamaEntity) && this.colony.isCoordInColony(entity.func_130014_f_(), new BlockPos(entity.func_213303_ch()));
        switch ((Explosions)((Object)MineColonies.getConfig().getServer().turnOffExplosionsInColonies.get())) {
            case DAMAGE_NOTHING: {
                getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.func_130014_f_(), new BlockPos(entity.func_213303_ch()));
            }
            case DAMAGE_PLAYERS: {
                List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).filter(entity -> !(entity instanceof ServerPlayerEntity)).collect(Collectors.toList());
                event.getAffectedEntities().removeAll(entitiesToRemove);
            }
            case DAMAGE_ENTITIES: {
                List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
                event.getAffectedBlocks().removeAll(blocksToRemove);
                break;
            }
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && MineColonies.getConfig().getServer().turnOffExplosionsInColonies.get() == Explosions.DAMAGE_NOTHING && this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            this.cancelEvent((Event)event, null, this.colony, Action.EXPLODE, new BlockPos(event.getExplosion().getPosition()));
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos()) && !(event instanceof PlayerInteractEvent.EntityInteract) && !(event instanceof PlayerInteractEvent.EntityInteractSpecific)) {
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            if (event instanceof PlayerInteractEvent.RightClickBlock && block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_HUTS)) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ACCESS_HUTS, event.getPos());
                return;
            }
            Permissions perms = this.colony.getPermissions();
            if (this.isFreeToInteractWith(block, event.getPos()) && perms.hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
                return;
            }
            if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue()) {
                if (!perms.hasPermission(event.getPlayer(), Action.RIGHTCLICK_BLOCK) && !(block instanceof AirBlock)) {
                    this.checkEventCancelation(Action.RIGHTCLICK_BLOCK, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                if (block instanceof ContainerBlock && !perms.hasPermission(event.getPlayer(), Action.OPEN_CONTAINER)) {
                    this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.OPEN_CONTAINER, event.getPos());
                    return;
                }
                if (event.getWorld().func_175625_s(event.getPos()) != null && !perms.hasPermission(event.getPlayer(), Action.RIGHTCLICK_ENTITY)) {
                    this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                ItemStack stack = event.getItemStack();
                if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.func_77973_b().func_219971_r()) {
                    return;
                }
                if (stack.func_77973_b() instanceof PotionItem) {
                    this.checkEventCancelation(Action.THROW_POTION, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
                    return;
                }
                if (stack.func_77973_b() instanceof ItemScanTool && !perms.hasPermission(event.getPlayer(), Action.USE_SCAN_TOOL)) {
                    this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.USE_SCAN_TOOL, event.getPos());
                }
            }
        }
    }

    private boolean isFreeToInteractWith(@Nullable Block block, BlockPos pos) {
        return block != null && (IColonyManager.getInstance().getCompatibilityManager().isFreeBlock(block) || this.colony.getFreeBlocks().contains(block) || ModTags.colonyProtectionException.func_230235_a_((Object)block)) || this.colony.getFreePositions().contains(pos) || IColonyManager.getInstance().getCompatibilityManager().isFreePos(pos);
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    private boolean checkEventCancelation(Action action, @NotNull PlayerEntity playerIn, @NotNull World world, @NotNull Event event, @Nullable BlockPos pos) {
        @NotNull PlayerEntity player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        BlockPos positionToCheck = pos;
        if (null == positionToCheck) {
            positionToCheck = new BlockPos(player.func_213303_ch());
        }
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.func_130014_f_(), positionToCheck) && !this.colony.getPermissions().hasPermission(player, action)) {
            if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && !world.field_72995_K && this.colony.isValidAttackingPlayer(playerIn)) {
                return false;
            }
            this.cancelEvent(event, (Entity)player, this.colony, action, positionToCheck);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.isFreeToInteractWith(null, event.getPos()) && this.colony.getPermissions().hasPermission(event.getPlayer(), Action.ACCESS_FREE_BLOCKS)) {
            return;
        }
        this.checkEventCancelation(Action.RIGHTCLICK_ENTITY, event.getPlayer(), event.getWorld(), (Event)event, event.getPos());
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        if (this.checkEventCancelation(Action.TOSS_ITEM, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, new BlockPos(event.getPlayer().func_213303_ch()))) {
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        this.checkEventCancelation(Action.PICKUP_ITEM, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, new BlockPos(event.getPlayer().func_213303_ch()));
    }

    @SubscribeEvent
    public void on(FillBucketEvent event) {
        @Nullable BlockPos targetBlockPos = null;
        if (event.getTarget() instanceof BlockRayTraceResult) {
            targetBlockPos = ((BlockRayTraceResult)event.getTarget()).func_216350_a();
        } else if (event.getTarget() instanceof EntityRayTraceResult) {
            targetBlockPos = new BlockPos(((EntityRayTraceResult)event.getTarget()).func_216348_a().func_213303_ch());
        }
        this.checkEventCancelation(Action.FILL_BUCKET, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, targetBlockPos);
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancelation(Action.SHOOT_ARROW, event.getPlayer(), event.getPlayer().func_130014_f_(), (Event)event, new BlockPos(event.getPlayer().func_213303_ch()));
    }

    @SubscribeEvent
    public void on(LivingHurtEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof EntityCitizen && ((EntityCitizen)event.getSource().func_76346_g()).getCitizenColonyHandler().getColonyId() == this.colony.getID() && this.colony.getRaiderManager().isRaided() && !this.colony.getPermissions().hasPermission((PlayerEntity)event.getEntity(), Action.GUARDS_ATTACK)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof MonsterEntity) {
            return;
        }
        @NotNull PlayerEntity player = EntityUtils.getPlayerOfFakePlayer(event.getPlayer(), event.getPlayer().func_130014_f_());
        if (((Boolean)MineColonies.getConfig().getServer().enableColonyProtection.get()).booleanValue() && this.colony.isCoordInColony(player.func_130014_f_(), new BlockPos(player.func_213303_ch()))) {
            Permissions perms = this.colony.getPermissions();
            if (event.getTarget() instanceof EntityCitizen) {
                AbstractEntityCitizen citizen = (AbstractEntityCitizen)event.getTarget();
                if (citizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && perms.hasPermission(event.getPlayer(), Action.GUARDS_ATTACK)) {
                    return;
                }
                if (perms.hasPermission(event.getPlayer(), Action.ATTACK_CITIZEN)) {
                    return;
                }
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ATTACK_CITIZEN, new BlockPos(event.getTarget().func_213303_ch()));
                return;
            }
            if (!(event.getTarget() instanceof MobEntity) && !perms.hasPermission(event.getPlayer(), Action.ATTACK_ENTITY)) {
                this.cancelEvent((Event)event, (Entity)event.getPlayer(), this.colony, Action.ATTACK_ENTITY, new BlockPos(event.getTarget().func_213303_ch()));
            }
        }
    }
}

